//
//  GHScannedDevice.h
//  Garmin Health
//
//  Created by Johnson, Garrett on 4/15/16.
//  Copyright © 2016 Garmin International, Inc. or its affiliates. All rights reserved.
//

//#import <Foundation/Foundation.h>
#import <UIKit/UIKit.h>
#import "GHDeviceTypes.h"

/**
 *  Information about a found Garmin device. Created by a scan.
 */
@interface GHScannedDevice : NSObject <NSCoding>

/** Unique device identifier */
@property (nonatomic, readonly) NSUUID * identifier;

/** Device name as reported by the device */
@property (nonatomic, readonly) NSString * friendlyName;

/** Code device uses for pairing, used to distinguish between multiple devices in pairing mode */
@property (nonatomic, readonly) NSString * passcode;

/** Type of Garmin device */
@property (nonatomic, readonly) GHDeviceTypes type;

/** Image of the Garmin device */
@property (nonatomic, readonly) UIImage *image;


#pragma mark - Methods
/** NS_UNAVAILABLE */
+ (instancetype)new NS_UNAVAILABLE;
/** NS_UNAVAILABLE */
- (instancetype)init NS_UNAVAILABLE;


@end
